
'---------------------------------------------------------------------
'
'  HAMEG GmbH
'  Sample program for Interface HO79
'  Compiler QuickBASIC Version 4.5
'  Compiler call :
'    QB /L QB.QLB GPIB.BAS
'
'  Please regard
'   1. device adddress ADRS% identical to HO79 device address
'   2. GPIB ROM address determined by DEF SEG accordingly!
'
'---------------------------------------------------------------------


INITIALIZ:
  DEF SEG = &HCC00               'GPIB ROM address
  MADDR% = 21                    '"my" device address
  ADRS% = 11                     'device address of interface
  LEVEL% = 0                     'Level 0 = cystem controller
  INIT% = 0                      'Reset GPIB
  IWSD% = 30                     'Offset address for
					'TRANSMIT COMMANDS
  IRSD% = 33                     'Offset address for
					'RECEIVE COMMANDS
  IWD% = 36                       'Offset address for
					'TRANSMIT DATA
  IRD% = 39                       'Offset address for
					'RECEIVE DATA
  IWDA% = 200                     'Offset address for TRANSMIT ARRAY
  IRDA% = 203                     'Offset address for RECEIVE ARRAY
  ISPL% = 12                      'Offset address for SERIAL POLLING
  IPPL% = 15                      'Offset address for SERIAL POLLING

' All addresses given for compiler, not for interpreter

'---------------------------------------------------------------------
  CLS
  GOSUB GPIBINIT

  KEY(1) ON
  KEY(10) ON
  ON KEY(1) GOSUB ID
  ON KEY(10) GOSUB GOHOME

  GOSUB FKTLINE

WAITING:
  GOTO WAITING

GOHOME:
  END


'---------------------------------------------------------------------

FKTLINE:
  LOCATE 1, 1
  PRINT "  F1-ID?                                                               F10-QUIT "
  PRINT "                                                                                "
  PRINT "                                                                                "
  PRINT "                                                                                "
  RETURN

'---------------------------------------------------------------------

ID:
  TD$ = "ID?"
  R$ = "                                                                                "
  DEF SEG = &HCC00
  CALL ABSOLUTE(ADRS%, TD$, STATUS%, IWD%)
  CALL ABSOLUTE(R$, LENGTH%, ADRS%, STATUS%, IRD%)
  DEF SEG
  PRINT R$
  END
  RETURN

'---------------------------------------------------------------------
'---------------------------------------------------------------------
GPIBINIT:
  DEF SEG = &HCC00
  CALL ABSOLUTE(MADDR%, LEVEL%, INIT%) 'Initialization

'---------------------------------------------------------------------
  DEF SEG
  TS$ = TIME$
SLEEP1:
  IF TS$ = TIME$ GOTO SLEEP1
  TS$ = TIME$
SLEEP2:
  IF TS$ = TIME$ GOTO SLEEP2

  RETURN
'---------------------------------------------------------------------


